<?php
// checkgmapkey.php

include '../include/conn.php'; // DB connection file

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Decode incoming JSON
$input = json_decode(file_get_contents('php://input'), true);

// Validate key
if (!isset($input['key']) || empty(trim($input['key']))) {
    echo json_encode([
        "status" => false,
        "message" => "License key is missing."
    ]);
    exit;
}

$key = trim($input['key']);

// DB Connection check
if ($conn->connect_error) {
    echo json_encode([
        "status" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]);
    exit;
}

// Fetch license key
$stmt = $conn->prepare("SELECT is_active, expire_at FROM license_keys WHERE license_key = ? LIMIT 1");
$stmt->bind_param("s", $key);
$stmt->execute();
$result = $stmt->get_result();

// Key validation logic
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    if (!$row['is_active']) {
        echo json_encode([
            "status" => false,
            "message" => "License key is deactivated."
        ]);
    } elseif (!empty($row['expire_at']) && strtotime($row['expire_at']) < time()) {
        echo json_encode([
            "status" => false,
            "message" => "License key has expired."
        ]);
    } else {
        echo json_encode([
            "status" => true,
            "message" => "License key is valid."
        ]);
    }

} else {
    echo json_encode([
        "status" => false,
        "message" => "License key not found."
    ]);
}

// Cleanup
$stmt->close();
$conn->close();
